#include <iostream>
#include <vector>
#include <cstdio>
#include <cmath>
#include <algorithm>

using namespace std;

const int MAXN = 50000;
int N;
int xs[MAXN], rs[MAXN];

typedef pair < double, bool > event_t;
event_t events[2 * MAXN];

bool check(double y) {
	y /= 2;
	int m = 0;
	for(int i = 0; i < N; i++) {
		if(rs[i] > y) {
			double t = sqrt(double(rs[i]) * rs[i] - y * y);
			events[m++] = make_pair(xs[i] - t, true);
			events[m++] = make_pair(xs[i] + t, false);
		}
	}
	sort(events, events + m);
	int levels = 0;
	double x = 0;
	for(int i = 0; i < m; i++) {
		event_t e = events[i];
		if(e.second) {
			if(levels == 0) x = e.first;
			++levels;
		} else {
			--levels;
			if(levels == 0 && e.first - x >= 2 * y) return true;
		}
	}
	return false;
}

bool solveOne() {
	scanf("%d", &N);
	if(N == 0) return false;
	for(int i = 0; i < N; i++) {
		scanf("%d%d", &xs[i], &rs[i]);
	}
	double l = 0.0, r = 1e5;
	for(int it = 0; it < 50; it++) {
		double m = (l + r) / 2.0;
		if(check(m))
			l = m;
		else
			r = m;
	}
	double result = (l + r) * 0.5;
	printf("%.10lf\n", result);
	return true;
}

int main() {
	while(solveOne())
		;
	return 0;
}